@include('admin/header')
<div class="wrapper">
    <!-- Sidebar  -->
    @include('admin/sidebar')
    <!-- Page Content  -->
    <div id="content">
        @include('admin/nav')
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mb-5">
                    <h2>LISTA DE CURSOS</h2>
                </div>
                <div class="col-md-12 mt-5">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif
                    @php
                    $numeroFila = ($paginaActual - 1) * $elementosPorPagina;
                    @endphp

                    <table id="cursos" class="table table-striped table-bordered nowrap" style="width:100%"
                        aria-describedby="mydesc">
                        <thead>
                            <tr>
                                <th>Nº Orden</th>
                                <th>Curso</th>
                                <th>Instructor</th>
                                <th>Actual / Original (Precios)</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($cursos as $curso)
                            <tr>
                                <td>{{ ++$numeroFila }}</td>
                                {{-- <td>{{ $curso->rownum }}</td> --}}
                                <td>{{ $curso->nombre }}</td>
                                <td>{{ $curso->instructor }}</td>
                                <td>{{ $curso->precio }}</td>
                                <td class="accion">
                                    <a href="javascript:void(0)" data-id="{{ $curso->id }}" data-toggle="modal"
                                        data-target="#actualizarCursoModal" class="actualizarCursoBtn">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a>
                                    <a href="javascript:void(0)" data-id="{{ $curso->id }}" data-toggle="modal"
                                        data-target="#eliminarCursoModal" class="borrar">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>

                                    @if ($loop->first && $cursos->currentPage() == 1)
                                    <a href="javascript:void(0)" data-id="{{ $curso->id }}" data-direccion="2"
                                        data-toggle="modal" data-target="#cambiarOrdenCursoModal"><i
                                            class="far fa-long-arrow-down down abajo"></i></a>
                                    @elseif ($loop->last && $cursos->currentPage() == $cursos->lastPage())
                                    <a href="javascript:void(0)" data-id="{{ $curso->id }}" data-direccion="1"
                                        data-toggle="modal" data-target="#cambiarOrdenCursoModal"><i
                                            class="far fa-long-arrow-up arriba"></i></a>
                                    @else
                                    <a href="javascript:void(0)" data-id="{{ $curso->id }}" data-direccion="2"
                                        data-toggle="modal" data-target="#cambiarOrdenCursoModal"><i
                                            class="far fa-long-arrow-down down abajo"></i></a>
                                    <a href="javascript:void(0)" data-id="{{ $curso->id }}" data-direccion="1"
                                        data-toggle="modal" data-target="#cambiarOrdenCursoModal"><i
                                            class="far fa-long-arrow-up arriba"></i></a>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $cursos->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="eliminarCursoModal" tabindex="-1" role="dialog" aria-labelledby="eliminarCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eliminarCursoModalLabel">Eliminar curso</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                ¿Estás seguro de que quieres eliminar este curso?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <form id="eliminarCursoForm" action="/desactivar-curso/{id_curso}" method="POST">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="btn btn-danger">Confirmar</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="cambiarOrdenCursoModal" tabindex="-1" role="dialog"
    aria-labelledby="eliminarCursoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eliminarCursoModalLabel">Cambiar orden curso</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                ¿Estás seguro de que quieres cambiar el orden de este curso?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <form id="cambiarOrdenCursoForm" action="/cambiar-order-curso" method="POST">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="btn btn-danger">Confirmar</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="actualizarCursoModal" tabindex="-1" role="dialog" aria-labelledby="eliminarCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eliminarCursoModalLabel">Actualizar curso</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="/actualizar-curso" method="POST" enctype="multipart/form-data" id="actualizarCursoForm">
                    @csrf
                    @method('PUT')
                    <h4 class="mb-4 mt-4">Información del curso</h4>
                    <div class="row">
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label for="curso">Nombre de curso</label>
                                <input class="form-control" type="text" name="nombre_curso" id="nombre_curso"
                                    value="{{ old('nombre_curso') }}">
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label for="precio_actual">Precio actual</label>
                                <input class="form-control" type="text" name="precio_actual" id="precio_actual"
                                    value="{{ old('precio_actual') }}">
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label for="precio_original">Precio original
                                    (opcional)</label>
                                <input class="form-control" type="text" name="precio_original" id="precio_original"
                                    value="{{ old('precio_original') }}">
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label>Subir la portada</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="imagen_curso" name="imagen_curso">
                                    <label class="custom-file-label" for="imagen_curso">
                                        <i class="fas fa-upload"></i> Upload
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label for="cantidad_cursos">Cantidad de cursos</label>
                                <input class="form-control" type="text" name="cantidad_cursos" id="cantidad_cursos"
                                    value="{{ old('cantidad_cursos') }}">
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label for="cantidad_paquetes">Cantidad de paquetes</label>
                                <input class="form-control" type="text" name="cantidad_paquetes" id="cantidad_paquetes"
                                    value="{{ old('cantidad_paquetes') }}">
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label for="descripcion">Descripción</label>
                                <input class="form-control" type="text" name="descripcion" id="descripcion"
                                    value="{{ old('descripcion') }}">
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="form-group">
                                <label class="pt-xl-4 pt-lg-4 pt-md-4 pt-sm-4 pt-0"></label>
                                <div class="custom-control custom-switch">
                                    {{-- <input type="checkbox" class="custom-control-input" id="corona" name="corona">
                                    --}}
                                    <input type="checkbox" id="corona" name="corona" class="custom-control-input">

                                    <label class="custom-control-label" for="corona">Asignar
                                        corona</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="contenido">Contenido del Curso</label>
                                <textarea rows="10" id="contenido" name="contenido">{{ old('contenido') }}</textarea>
                            </div>
                        </div>
                        <input type="hidden" name="id_curso" id="id_curso">
                    </div>
                    {{-- <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="default-btn next-step">
                                Siguiente
                            </button>
                        </div>
                    </div> --}}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-danger">Confirmar</button>
            </div>
            </form>
        </div>
    </div>
</div>
<script>
    $('#eliminarCursoModal').on('show.bs.modal', function(e) {
        var borrarLink = $(e.relatedTarget);
        var id = borrarLink.data('id');
        var eliminarCursoForm = $('#eliminarCursoForm');

        eliminarCursoForm.attr('action', '/desactivar-curso/' + id);
    });

    $('#cambiarOrdenCursoModal').on('show.bs.modal', function(e) {
        var cambiarOrdenLink = $(e.relatedTarget);
        var id = cambiarOrdenLink.data('id');
        var cambiarOrdenCursoForm = $('#cambiarOrdenCursoForm');
        var direccion = cambiarOrdenLink.data('direccion');

        cambiarOrdenCursoForm.attr('action', '/cambiar-order-curso/' + id + '/' + direccion);
    });

    $('#eliminarCursoForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });

    $('#cambiarOrdenCursoForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });

    let contenido = RedactorX('#contenido');
    $('.actualizarCursoBtn').click(function() {
        var id = $(this).data('id');

        $.get('/curso/' + id, function(data) {
            let curso = data.curso;
            $('#nombre_curso').val(curso.nombre);
            $('#precio_actual').val(curso.precio_actual);
            $('#precio_original').val(curso.precio_original);
            $('#cantidad_cursos').val(curso.cantidad_cursos);
            $('#cantidad_paquetes').val(curso.cantidad_paquetes);
            $('#descripcion').val(curso.descripcion);
            
            $('#corona').prop('checked', curso.corona);
            $('#id_curso').val(id);
            
            contenido.editor.setContent({ html: curso.contenido });
        });
    });

    $('#actualizarCursoModal').on('show.bs.modal', function(e) {
        var borrarLink = $(e.relatedTarget);
        var id = borrarLink.data('id');
        var actualizarCursoForm = $('#actualizarCursoForm');

        actualizarCursoForm.attr('action', '/actualizar-curso/' + id);
    });
    $('#actualizarCursoForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });
</script>
@include('admin/footer')